#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <readline/readline.h>

static char *initial_text = NULL;

void usage() {
	fprintf(stderr, "readpreprompt:\n");
	fprintf(stderr, "Kevin Pulo, kev@pulo.com.au, (c) 2006\n");
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "    readpreprompt <prompt> [initial_text]\n");
	fprintf(stderr, "Returns the entered text on stdout\n");
}

int set_initial_text(int count, int key) {
	int rc = 0;
	if (initial_text) {
		rc = rl_insert_text(initial_text);
	}
	return rc;
}

int main(int argc, char *argv[]) {
	char *reply = NULL;
	char *prompt = NULL;
	FILE *tmp;

	if (argc == 2) {
		prompt = argv[1];
	} else if (argc == 3) {
		prompt = argv[1];
		initial_text = argv[2];
	} else {
		usage();
		exit(1);
	}

	tmp = stdout;
	stdout = stderr;
	stderr = tmp;

	rl_startup_hook = (rl_command_func_t*) set_initial_text;
	reply = readline(prompt);
	fprintf(stderr, "%s", reply);

	return 0;
}

